/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper;

import java.util.Objects;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.INbt;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.util.NBTJsonUtil;

public class NBTWrapper
implements INbt {
    private final NBTTagCompound compound;

    public NBTWrapper(NBTTagCompound compound) {
        this.compound = compound;
    }

    @Override
    public void clear() {
        for (String name : this.compound.func_150296_c()) {
            this.compound.func_82580_o(name);
        }
    }

    @Override
    public boolean getBoolean(String key) {
        return this.compound.func_74767_n(key);
    }

    @Override
    public byte getByte(String key) {
        return this.compound.func_74771_c(key);
    }

    @Override
    public byte[] getByteArray(String key) {
        return this.compound.func_74770_j(key);
    }

    @Override
    public INbt getCompound(String key) {
        return Objects.requireNonNull(NpcAPI.Instance()).getINbt(this.compound.func_74775_l(key));
    }

    @Override
    public double getDouble(String key) {
        return this.compound.func_74769_h(key);
    }

    @Override
    public float getFloat(String key) {
        return this.compound.func_74760_g(key);
    }

    @Override
    public int getInteger(String key) {
        return this.compound.func_74762_e(key);
    }

    @Override
    public int[] getIntegerArray(String key) {
        return this.compound.func_74759_k(key);
    }

    @Override
    public String[] getKeys() {
        return this.compound.func_150296_c().toArray(new String[0]);
    }

    @Override
    public Object[] getList(String key, int type) {
        NBTTagList list = this.compound.func_150295_c(key, type);
        Object[] nbts = new Object[list.func_74745_c()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            if (list.func_150303_d() == 10) {
                nbts[i] = Objects.requireNonNull(NpcAPI.Instance()).getINbt(list.func_150305_b(i));
                continue;
            }
            if (list.func_150303_d() == 8) {
                nbts[i] = list.func_150307_f(i);
                continue;
            }
            if (list.func_150303_d() == 6) {
                nbts[i] = list.func_150309_d(i);
                continue;
            }
            if (list.func_150303_d() == 5) {
                nbts[i] = Float.valueOf(list.func_150308_e(i));
                continue;
            }
            if (list.func_150303_d() == 3) {
                nbts[i] = list.func_186858_c(i);
                continue;
            }
            if (list.func_150303_d() != 11) continue;
            nbts[i] = list.func_150306_c(i);
        }
        return nbts;
    }

    @Override
    public int getListType(String key) {
        NBTBase b = this.compound.func_74781_a(key);
        if (b.func_74732_a() != 9) {
            throw new CustomNPCsException("NBT tag " + key + " isn't a list", new Object[0]);
        }
        return ((NBTTagList)b).func_150303_d();
    }

    @Override
    public long getLong(String key) {
        return this.compound.func_74763_f(key);
    }

    @Override
    public NBTTagCompound getMCNBT() {
        return this.compound;
    }

    @Override
    public short getShort(String key) {
        return this.compound.func_74765_d(key);
    }

    @Override
    public String getString(String key) {
        return this.compound.func_74779_i(key);
    }

    @Override
    public int getType(String key) {
        return this.compound.func_150299_b(key);
    }

    @Override
    public boolean has(String key) {
        return this.compound.func_74764_b(key);
    }

    @Override
    public boolean isEqual(INbt nbt) {
        return nbt != null && this.compound.equals((Object)nbt.getMCNBT());
    }

    @Override
    public void merge(INbt nbt) {
        this.compound.func_179237_a(nbt.getMCNBT());
    }

    @Override
    public void remove(String key) {
        this.compound.func_82580_o(key);
    }

    @Override
    public void setBoolean(String key, boolean value) {
        this.compound.func_74757_a(key, value);
    }

    @Override
    public void setByte(String key, byte value) {
        this.compound.func_74774_a(key, value);
    }

    @Override
    public void setByteArray(String key, byte[] value) {
        this.compound.func_74773_a(key, value);
    }

    @Override
    public void setCompound(String key, INbt value) {
        if (value == null) {
            throw new CustomNPCsException("Value cant be null", new Object[0]);
        }
        this.compound.func_74782_a(key, (NBTBase)value.getMCNBT());
    }

    @Override
    public void setDouble(String key, double value) {
        this.compound.func_74780_a(key, value);
    }

    @Override
    public void setFloat(String key, float value) {
        this.compound.func_74776_a(key, value);
    }

    @Override
    public void setInteger(String key, int value) {
        this.compound.func_74768_a(key, value);
    }

    @Override
    public void setIntegerArray(String key, int[] value) {
        this.compound.func_74783_a(key, value);
    }

    @Override
    public void setList(String key, Object[] value) {
        NBTTagList list = new NBTTagList();
        int type = -1;
        for (Object nbt : value) {
            if (nbt instanceof INbt) {
                if (type == -1) {
                    type = 10;
                } else if (type != 10) continue;
                list.func_74742_a((NBTBase)((INbt)nbt).getMCNBT());
                continue;
            }
            if (nbt instanceof String) {
                if (type == -1) {
                    type = 8;
                } else if (type != 8) continue;
                list.func_74742_a((NBTBase)new NBTTagString((String)nbt));
                continue;
            }
            if (nbt instanceof Double) {
                if (type == -1) {
                    type = 6;
                } else if (type != 6) continue;
                list.func_74742_a((NBTBase)new NBTTagDouble(((Double)nbt).doubleValue()));
                continue;
            }
            if (nbt instanceof Float) {
                if (type == -1) {
                    type = 5;
                } else if (type != 5) continue;
                list.func_74742_a((NBTBase)new NBTTagFloat(((Float)nbt).floatValue()));
                continue;
            }
            if (nbt instanceof Integer) {
                if (type == -1) {
                    type = 3;
                } else if (type != 3) continue;
                list.func_74742_a((NBTBase)new NBTTagInt(((Integer)nbt).intValue()));
                continue;
            }
            if (!(nbt instanceof int[])) continue;
            if (type == -1) {
                type = 11;
            } else if (type != 11) continue;
            list.func_74742_a((NBTBase)new NBTTagIntArray((int[])nbt));
        }
        this.compound.func_74782_a(key, (NBTBase)list);
    }

    @Override
    public void setLong(String key, long value) {
        this.compound.func_74772_a(key, value);
    }

    @Override
    public void setShort(String key, short value) {
        this.compound.func_74777_a(key, value);
    }

    @Override
    public void setString(String key, String value) {
        this.compound.func_74778_a(key, value);
    }

    @Override
    public String toJsonString() {
        return NBTJsonUtil.Convert(this.compound);
    }
}

